Attribute VB_Name = "baseLineDimensioning"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.

'Visual Basic example to generate linear dimensions with respect to a specified datum
'for a selected set of linear dimensions.

'Global data

Dim app As ProDESKTOP           ' variable used to hold the ProDESKTOP object
Dim dwg As aDrawing             ' variable used to hold the aDrawing object
Dim datum As zGeometry          ' variable used to hold the datum
Dim firstView As aHiddenLine    ' variable used to hold the firstView
Dim doc As DrawingDocument      ' variable used to hold the DrawingDocument

Dim placement As Double
Dim textHeight As Double        'variable used to hold the text height of the dimension
Dim Position As ZVector         'variable used to hold the Position of the dimension

Dim dimValueSet As New Collection   'A collection used to hold a set of dimension values
Dim planeSet As New Collection      'A collection used to hold a set of zplanes
Dim viewSet As New Collection       'A collection used to hold a set of views

Sub baseLineDimensioning()

    Set app = CreateObject("ProDESKTOP.Application")
    
    On Error GoTo ErrorHandler
    Set doc = app.GetActiveDoc
    On Error GoTo 0
    
    If Not doc Is Nothing Then
        Set dwg = doc.GetDrawing
    Else
        MsgBox "Active Drawing document is not presetnt"
    End If
    
    'Initialize placement
    Let placement = 0.005
    
    'Select the datum for base line dimensioning.
    Call SelectDatum
           
    'Create the base line dimensions from the existing set of dimensions
    Call CreateBaseLineDimensions
    
    Call resetGlobalVariables

Exit Sub

ErrorHandler:
    If Err.Number = 13 Then MsgBox "The active document is a not a drawing document"

End Sub

Private Function SelectDatum()

    'Take the helm
    Dim api As helm
    Set api = app.TakeHelm
    
    'Select the datum
    MsgBox ("Please select the datum for base line dimensioning")
    api.CommitCalls "Select Datum", True
    
    Set datumSet = doc.GetSelection("Graphic")
    
    'Create an ItClass
    Dim itCls As ItClass
    Set itCls = app.GetClass("It")

    Dim datumSetIt As Iterator
    Set datumSetIt = itCls.CreateAObjectIt(datumSet)
    
    'Get the datum
    Set graph = datumSetIt.start
    Set datum = doc.GetPaperGeometry(graph)
    Set firstView = datum.GetInstance
    
    api.CommitCalls "datum", False

End Function

Private Function CreateBaseLineDimensions()


    'Take the helm
    Dim api As helm
    Set api = app.TakeHelm
        
    'Select the Linear Dimensions
    MsgBox ("Please select Linear Dimensions")
    api.CommitCalls "Select Linear Dimensions", True
    
    'Create a set containing linear dimensions
    Dim dimLineSet As ObjectSet
    Set dimLineSet = doc.GetSelection("LinearDimLine")
    
    'Create an ItClass
    Dim itCls As ItClass
    Set itCls = app.GetClass("It")
    
    'Create an iterator for linear dimensions
    Dim dimLineSetIt As Iterator
    Set dimLineSetIt = itCls.CreateAObjectIt(dimLineSet)
    
    'Exit sub if not a linear dimension
    Dim dimLine As aLinearDimLine
    On Error GoTo notLinearDim
    Set dimLine = dimLineSetIt.start
    
    'Get the position of dimension line
    Set Position = dimLine.GetPosition
    
    'Get the callout group set
    Dim groupSet As ObjectSet
    Set groupSet = dimLine.GetCalloutGroups
    
    'Get the callout group
    Dim group As aCalloutGroup
    Set group = groupSet.GetAnyMember
    
    'Get the text height of the callout
    textHeight = group.GetTextHeight
    
    'Iterate through the dimension lines
    Do While dimLineSetIt.IsActive
    
        Set dimLine = dimLineSetIt.Current
        
        'Store the linear dimensions
        Call storeDimensions(dimLine)
        
        'Delete the linear dimension
        dimLine.Delete
        
        dimLineSetIt.Next
    Loop
    
    'Call the subroutine CreateDimension
    Call CreateDimensions
            
    api.CommitCalls "Create Dimensions", False
    
    Exit Function
    
notLinearDim:
    MsgBox ("Could not create baseline dimensions")

    
End Function
    
    
'Subroutine used to store the zPlane set and view set
Private Function storeDimensions(dimLine)
    
    'Get the aDimension from aLinearDimLine
    Dim dimension As aDimension
    Set dimension = dimLine.GetDefinition
    
    'Get the zMidPlane from the aDimension
    Dim feature As zGeometry
    Set feature = dimension.GetGeometry
    
    'Get the first and second zPlane from the feature
    Dim plane1 As zPlane
    Dim plane2 As zPlane
    Set plane1 = feature.GetFirst
    Set plane2 = feature.GetSecond
    
    'Create a Plane set
    planeSet.Add Item:=plane1
    planeSet.Add Item:=plane2
    
    'Get the first and second aHiddenLine from the aLinearDimLine
    Dim view1 As aHiddenLine
    Dim view2 As aHiddenLine
    Set view1 = dimLine.GetFirstView
    Set view2 = dimLine.GetSecondView
    
    'Create a view/hiddenLine set
    viewSet.Add Item:=view1
    viewSet.Add Item:=view2
       
End Function

'Subroutine used to create the base line dimensions

Private Function CreateDimensions()

    Dim dwgFeature, design, ddetail, defn, dimension, dimObjValue
    Dim dimValue As Double
    
    'Create DimensionClass, DimLineTextClass, DimensionCallout and DimTolClass
    
    Dim dimCls As DimensionClass
    Set dimCls = app.GetClass("Dimension")
    
    Dim dimCalloutCls As DimensionCalloutClass
    Set dimCalloutCls = app.GetClass("DimensionCallout")
    
    Dim dimTolCls As DimTolClass
    Set dimTolCls = app.GetClass("DimTol")
    
    For w = 1 To viewSet.count
    
        'Create a dimension between the selected datum and the geometry obtained
        Set dwgFeature = planeSet(w).GetOccurrence(viewSet(w))
        Set design = viewSet(w).GetParent("View").GetDesign
        Set ddetail = dwg.GetDetail(design, False)
          
        Set defn = CreateLinearDefinition(datum, dwgFeature)
        
        Set dimension = dimCls.CreateDimension(ddetail, 1, defn)
    
        'Get the dimension value
        Set dimObjValue = dimension.GetValue
        dimValue = dimObjValue.GetSystemValue
        
        'Put the dimension value in the dimValueSet
        dimValueSet.Add Item:=dimValue
        
    Next w
    
    'Iterate through the dimValueSet to check dimensions having same values
    'and remove the dimension value, view ,and plane if the condition is true
    
    Let Found = False
    Let dimCountAfter = dimValueSet.count
    Do Until Found
        For q = 1 To dimValueSet.count
            For e = 1 To dimValueSet.count
                If (q <> e) Then
                    If (dimValueSet(q) = dimValueSet(e)) Then
                        dimValueSet.Remove (e)
                        viewSet.Remove (e)
                        planeSet.Remove (e)
                        dimCountAfter = dimValueSet.count
                        Found = False
                        exitFor = True
                        Exit For
                    End If
                End If
            Next e
            If exitFor Then
                exitFor = False
                Exit For
            End If
        Next q
    If (q = dimCountAfter + 1) Then
        Found = True
    End If
    Loop
    
    
    'Create the linear dimension between the datum and the sorted geometry
    For v = 1 To viewSet.count
    
        Set dwgFeature = planeSet(v).GetOccurrence(viewSet(v))
        Set design = viewSet(v).GetParent("View").GetDesign
        Set ddetail = dwg.GetDetail(design, False)
        
        Set defn = CreateLinearDefinition(datum, dwgFeature)
        
        Set newDimension = dimCls.CreateDimension(ddetail, 1, defn)
        
        Let x = Position.GetAt(0)
        Let Y = Position.GetAt(1)
        Let z = 0
        posX = x + placement
        posY = Y + placement
        Set Position = app.GetClass("Vector").CreateVector(posX, posY, z)
        placement = placement + 0.005
        
        Dim LineDim As aDimLine
        Set LineDim = app.GetClass("LinearDimLine").CreateLinearDimLine(Position, newDimension, firstView, viewSet(v))
        Set tolerance = dimTolCls.CreateDimTol(ddetail, newDimension)
        Set callout = dimCalloutCls.CreateDimensionCallout(tolerance)
        Set text = app.GetClass("DimLineText").CreateDimLineText(LineDim, callout, Position, textHeight)
        text.SetControlPoint 1, Position
        dwg.AddDimLine LineDim
        dwg.AddCenterLineUser LineDim
      
    Next v

End Function



Private Function CreateLinearDefinition(first As zGeometry, second) As zMidPlane
    
    Dim refsCollection As New Collection
    Dim viewsCollection As New Collection
    Dim planesCollection As New Collection
    
    Dim view1 As aHiddenLine
    Dim view2 As aHiddenLine
    Set view1 = first.GetInstance()
    Set view2 = second.GetInstance()
    viewsCollection.Add Item:=view1
    viewsCollection.Add Item:=view2
    
    
    Dim ref1 As zGeometry
    Set ref1 = first.GetOriginal()
    refsCollection.Add Item:=ref1
        
    Dim ref2 As zGeometry
    Set ref2 = second.GetOriginal()
    refsCollection.Add Item:=ref2
    
    Dim plane1 As zPlane
    Dim plane2 As zPlane
    Set plane1 = ref1.Clone
    Set plane2 = ref2.Clone
    planesCollection.Add Item:=plane1
    planesCollection.Add Item:=plane2
    

    Dim i As Integer
    For i = 1 To 2
        If (Not planesCollection(i) Is Nothing) Then GoTo forNext
        Dim other As Integer
        other = 2 - i
        If Not planesCollection(other) Is Nothing Then
            Set planesCollection(i) = app.GeClass("ParallelPlane").CreateParallelPlane(refsCollection(i).Clone, planesCollection(i).Clone, 1)
            GoTo forNext
        End If
        planesCollection(i) = PromoteUsingViewPlane(refsCollection(i), viewsCollection(i))
forNext:
    Next i
    
    If (planesCollection(1) Is Nothing And Not planesCollection(2) Is Nothing) Then
        Set planesCollection(1) = app.GetClass("ParallelPlane").CreateParallelPlane(refsCollection(i).Clone, planesCollection(i).Clone, 1)
    End If
    If (Not planesCollection(1) Is Nothing And Not planesCollection(2) Is Nothing) Then
        Set CreateLinearDefinition = app.GetClass("MidPlane").CreateMidPlane(planesCollection(1), planesCollection(2), True)
    End If
    
    
End Function



Private Function PromoteUsingViewPlane(geom As zGeometry, view As aHiddenLine) As zPlane

    
    Dim plane As zPlane
    Set plane = app.GetClass("AngledPlane").CreateAngledPlane(geom.Clone, app.GetClass("viewPlane").CreateViewPlane(view, 1.57))
    
    Set PromoteUsingViewPlane = plane
       
End Function

Private Function resetGlobalVariables()

    Set dwg = Nothing
    Set datum = Nothing
    Set firstView = Nothing
    Set doc = Nothing
    Set Position = Nothing
    
    Set dimValueSet = Nothing
    Set planeSet = Nothing
    Set viewSet = Nothing
    
End Function
